(function() {
	var canvas;
	var color1;
	var color2;
	function load(){
		selectColors();
		canvas = document.getElementById("background");
		var body = document.body;
		if(body.namespaceURI == "ns.innes.xpf.3"){
			canvas.addEventListener("resize", paint);
			paint();
			body.addEventListener("activate", contentChanged, true);
		}else {
			window.addEventListener("resize", resizeAndPaint);
			resizeAndPaint();
			body.addEventListener("smil-active", contentChanged, true);
		}
	}

	function contentChanged(event){
		var localName = event.target.localName;
		if(localName.indexOf("smil-") == 0) {
			localName = localName.substring(5);
		}
		if(localName == "par" || localName == "seq" || localName == "begin" 
			|| localName == "switch" || localName == "excl" || localName == "script"){
			return;
		}
		selectColors();
		paint();
	}
	function selectColors(){
		var vals = [];
		for(var i = 0; i < 6; ++i){
			vals[i] = Math.floor(Math.random() * 255);
		}
		color1 = "rgba(" + vals[0] + "," + vals[1] + "," + vals[2] + ",255)";
		color2 = "rgba(" + vals[3] + "," + vals[4] + "," + vals[4] + ",255)";
	}
	function resizeAndPaint(){
		canvas.height = canvas.clientHeight;
		canvas.width = canvas.clientWidth;
		paint();
	}
	function paint(){
		var context = canvas.getContext("2d");
		var width = context.canvas.width;
		var height = context.canvas.height;
		var alpha = "0.6";
		var max = height > width ? height : width;
		var lingrad = context.createLinearGradient(0, 0, width, height);
		lingrad.addColorStop(0, color1);
		lingrad.addColorStop(1, color2);

		context.fillStyle = lingrad;
		context.fillRect(0, 0, context.canvas.width, context.canvas.height);
	}
	if(document.readyState == "loading"){
		document.addEventListener("DOMContentLoaded", load);
	}else{
		load();
	}
})();
